using System;
using Server;
using Server.Engines.Craft;
using Server.Mobiles;
using Server.Network;
using System.Collections.Generic;
using System.Collections;

namespace Server.Items
{
	public class RecipeScrollMLCarp : Item
	{
		public override int LabelNumber { get { return 1074560; } } // recipe scroll

		public override void GetProperties( ObjectPropertyList list )
		{
			base.GetProperties( list );
			list.Add( "Elfi vyrobky ze dreva a kamene" );
		}

		[Constructable]
		public RecipeScrollMLCarp() : base( 0x2831 )
		{
		}

		public RecipeScrollMLCarp( Serial serial ) : base( serial )
		{
		}

		public override void OnDoubleClick( Mobile from )
		{
			
         if( !IsChildOf( from.Backpack ) )
         {
				from.SendLocalizedMessage( 1060640 ); // The item must be in your backpack to use it.
				return;
         }

			if( from is PlayerMobile )
			{
				PlayerMobile pm = from as PlayerMobile;
				if( !pm.HasRecipe( 100 ) )
				{
			      for ( int i = 100; i < 120; ++i )
			      {
			         pm.AcquireRecipe( i );
// 			         pm.SendMessage( "recipe no: {0}", i );
			      }
					this.Delete();
					pm.SendLocalizedMessage( 1073451, "Elfi vyrobky ze dreva a kamene" ); // You have learned a new recipe: ~1_RECIPE~
				}
				else
				{
					pm.SendLocalizedMessage( 1073427 ); // You already know this recipe.
				}
			}
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.WriteEncodedInt( 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadEncodedInt();
		}
	}
}
